<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Renderer for outputting the weeks course format.
 *
 * @package format_weeks
 * @copyright 2012 Dan Poltawski
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since Moodle 2.3
 */

namespace format_weeks\output;

use core_courseformat\output\section_renderer;

class renderer extends section_renderer {

    public function section_title($section, $course) {
        $title = $this->render(
            course_get_format($course)->inplace_editable_render_section_name($section)
        );

        if (!empty($section->section)) {
            // Localized label.
            $weeknum = $section->section;
            $title .= ' (' . get_string('weeklabel', 'format_weeks', $weeknum) . ')';
        }

        return $title;
    }

    public function section_title_without_link($section, $course) {
        $title = $this->render(
            course_get_format($course)->inplace_editable_render_section_name($section, false)
        );

        if (!empty($section->section)) {
            $weeknum = $section->section;
            $title .= ' (' . get_string('weeklabel', 'format_weeks', $weeknum) . ')';
        }

        return $title;
    }
}

